
$(function() {
	var urlvars = getUrlVars();
	var activityId = parseInt(urlvars['id'], 10);
	var activityIdMap = {"activityId":activityId};
	
	$('#div-two').on('click','button#next',function(e){
		// populate the user request info
		var aiMap = {"requestId":requestId};
		aiMap['shortName'] = $('#div-one input#short-name').val();
		aiMap['iRBApprovalNumber'] = $('#div-one input#irb-approval').val();
		aiMap['iRBExpirationDate'] = $('#div-one input#irb-expiration').val();
		aiMap['activityStartDate'] = $('#div-one input#start-date').val();
		aiMap['activityEndDate'] = $('#div-one input#end-date').val();
		// we don't allow modifying these values here even if they are passed to the server
		aiMap['officialName'] = '';
		aiMap['draft'] = true;
		aiMap['type'] = '';
		
		$.ajax({
			url:'../dart/saveActivityInfo.json',
			type:'POST',
			contentType:'application/json',
			dataType:'json',
			data:JSON.stringify(aiMap),
			success:function(data,textStatus,three) {
				if(textStatus==="success"){
					document.location='./project-participants.html?id='+activityId;
				}
				else {
					alert('error');
				}
			}
		});
		
	});
	
	// populate the user request info
	$.ajax({
		url:'../dart/getActivityInfo.json',
		type:'POST',
		contentType:'application/json',
		dataType:'json',
		data:JSON.stringify(activityIdMap),
		success:function(data,textStatus,three) {
			var projectName = Mustache.render($(".projectNameTemplate").html(),data);
			$('div#div-zero').html(projectName);
			var tableBody = Mustache.render($(".projectRowTemplate").html(),data);
			$('div#div-one table tbody').html(tableBody);
		}
	});
});

//Read a page's GET URL variables and return them as an associative array.
getUrlVars = function()
{
    var vars = [], hash;
    var hashes = window.location.href.slice(window.location.href.indexOf('?') + 1).split('&');
    for(var i = 0; i < hashes.length; i++)
    {
        hash = hashes[i].split('=');
        vars.push(hash[0]);
        vars[hash[0]] = hash[1];
    }
    return vars;
}